package com.afanticar.afantiopenapi.model.entity.adb;

import com.alibaba.fastjson.annotation.JSONType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 抖音主播信息
 * </p>
 *
 * @author Wsr
 * @since 2023-02-09
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("dws_fhl_mkms_author_action_day")
@ApiModel(value = "DwsFhlMkmsAuthorActionDay对象", description = "主播线索信息")
@JsonNaming(value = com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy.class)
@JSONType(naming = com.alibaba.fastjson.PropertyNamingStrategy.SnakeCase)
public class DwsFhlMkmsAuthorActionDay implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("进入私信人数")
    @TableField("session_entered_count")
    private Integer sessionEnteredCount;

    @ApiModelProperty("开口数")
    @TableField("user_speak_count")
    private Integer userSpeakCount;

    @ApiModelProperty("开口率")
    @TableField("user_speak_rate")
    private BigDecimal userSpeakRate;

    @ApiModelProperty("留电话人数")
    @TableField("pp_leads_count")
    private Integer ppLeadsCount;

    @ApiModelProperty("私信线索数")
    @TableField("message_leads_count")
    private Integer messageLeadsCount;

    @ApiModelProperty("3分钟回复率")
    @TableField("reply_within_3min_rate")
    private String replyWithin3minRate;

}
