package com.afanticar.afantiopenapi.model.entity.adb;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 抖音主播信息
 * </p>
 *
 * @author Wsr
 * @since 2023-02-09
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("dwd_douyin_author_info")
@ApiModel(value = "DwdDouyinAuthorInfo对象", description = "抖音主播信息")
public class DwdDouyinAuthorInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主播ID")
    @TableId("author_id")
    private String authorId;

    @ApiModelProperty("主播抖音号")
    @TableField("code")
    private String code;

    @ApiModelProperty("主播性别")
    @TableField("gender")
    private Integer gender;

    @ApiModelProperty("主播签名")
    @TableField("signature")
    private String signature;

    @ApiModelProperty("主播认证名称")
    @TableField("verify_name")
    private String verifyName;

    @ApiModelProperty("主播昵称")
    @TableField("nickname")
    private String nickname;

    @ApiModelProperty("抖音主播认证类型")
    @TableField("verification_type")
    private String verificationType;

    @ApiModelProperty("抖音主播认证名称")
    @TableField("verification_name")
    private String verificationName;

    @ApiModelProperty("主播头像")
    @TableField("avatar")
    private String avatar;

    @ApiModelProperty("经销商id")
    @TableField("dealer_id")
    private String dealerId;

    @ApiModelProperty("经销商名称")
    @TableField("dealer_name")
    private String dealerName;

    @ApiModelProperty("经销商城市code")
    @TableField("dealer_city_code")
    private Long dealerCityCode;

    @ApiModelProperty("经销商城市名称")
    @TableField("dealer_city_name")
    private String dealerCityName;

    @ApiModelProperty("经销商地区code")
    @TableField("dealer_county_code")
    private Long dealerCountyCode;

    @ApiModelProperty("经销商地区名称")
    @TableField("dealer_county_name")
    private String dealerCountyName;

    @ApiModelProperty("经销商省份code")
    @TableField("dealer_province_code")
    private Long dealerProvinceCode;

    @ApiModelProperty("经销商省份名称")
    @TableField("dealer_province_name")
    private String dealerProvinceName;

    @ApiModelProperty("主播总点赞数")
    @TableField("like_count_total")
    private Integer likeCountTotal;

    @ApiModelProperty("主播总视频数")
    @TableField("aweme_count_total")
    private Integer awemeCountTotal;

    @ApiModelProperty("主播总粉丝数")
    @TableField("fans_count_total")
    private Integer fansCountTotal;

    @ApiModelProperty("主播抖音粉丝数")
    @TableField("fans_dy_count")
    private Integer fansDyCount;

    @ApiModelProperty("主播头条粉丝数")
    @TableField("fans_tt_count")
    private Integer fansTtCount;

    @ApiModelProperty("主播火山粉丝数")
    @TableField("fans_hs_count")
    private Integer fansHsCount;

    @ApiModelProperty("更新时间")
    @TableField(value = "mtime", fill = FieldFill.INSERT_UPDATE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date mtime;

    @ApiModelProperty("账号类型：10经销商未分类，11经销商官号，12经销商个人号，13经销商营销号；20主机厂号未分类；21主机厂官号，22主机厂营销号；41汽车KOL,14:经销商售后，15:经销商二手车,30:经销商大区号 ; NULL 既不是品牌主播号，也不是经销商主播号，又不是汽车分类主播号的主播号")
    @TableField("account_type")
    private Integer accountType;

    @ApiModelProperty("主播状态, 0正常;1删除")
    @TableField("author_status")
    private Integer authorStatus;

}
