package com.afanticar.afantiopenapi.service;

import com.afanticar.afantiopenapi.mapper.adb.DwdDouyinAuthorInfoMapper;
import com.afanticar.afantiopenapi.mapper.adb.DwdDouyinAwemeInfoMapper;
import com.afanticar.afantiopenapi.mapper.adb.DwdDouyinLiveInfoMapper;
import com.afanticar.afantiopenapi.mapper.adb.DwsFhlMkmsAuthorActionDayMapper;
import com.afanticar.afantiopenapi.model.entity.adb.DwdDouyinAuthorInfo;
import com.afanticar.afantiopenapi.model.entity.adb.DwdDouyinAwemeInfo;
import com.afanticar.afantiopenapi.model.entity.adb.DwdDouyinLiveInfo;
import com.afanticar.afantiopenapi.model.entity.adb.DwsFhlMkmsAuthorActionDay;
import com.afanticar.afantiopenapi.model.vo.BasePageVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author chin
 * @contact chenyan@afanticar.com
 * @since 2024/1/22/022
 */
@Service
public class AionOpenService {

    private final String principalId = "869753082057052160";

    @Resource
    DwdDouyinAuthorInfoMapper dwdDouyinAuthorInfoMapper;

    @Resource
    DwdDouyinAwemeInfoMapper dwdDouyinAwemeInfoMapper;

    @Resource
    DwdDouyinLiveInfoMapper dwdDouyinLiveInfoMapper;

    @Resource
    DwsFhlMkmsAuthorActionDayMapper dwsFhlMkmsAuthorActionDayMapper;

    public List<DwdDouyinAuthorInfo> douyinAuthorInfo() {
        QueryWrapper<DwdDouyinAuthorInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("principal_ids", principalId).eq("author_status", 0);
        return dwdDouyinAuthorInfoMapper.selectList(queryWrapper);
    }

    public BasePageVO<DwdDouyinAwemeInfo> douyinAwemeInfo(String publishTimeGte, String publishTimeLt, Integer pageNum, Integer pageSize) {
        PageHelper.orderBy(" publish_time DESC ");
        IPage<DwdDouyinAwemeInfo> page = new Page<>(pageNum, pageSize);
        IPage<DwdDouyinAwemeInfo> awemePage = dwdDouyinAwemeInfoMapper.getPage(page, principalId, publishTimeGte, publishTimeLt);
        return BasePageVO.restPage(pageNum, (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), awemePage.getRecords());
    }

    public BasePageVO<DwdDouyinLiveInfo> douyinLiveInfo(String publishTimeGte, String publishTimeLt, Integer pageNum, Integer pageSize) {
        PageHelper.orderBy(" publish_time DESC ");
        IPage<DwdDouyinLiveInfo> page = new Page<>(pageNum, pageSize);
        IPage<DwdDouyinLiveInfo> awemePage = dwdDouyinLiveInfoMapper.getPage(page, principalId, publishTimeGte, publishTimeLt);
        return BasePageVO.restPage(pageNum, (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), awemePage.getRecords());
    }

    public BasePageVO<DwsFhlMkmsAuthorActionDay> douyinFhlMkmsAuthorInfo(String statisticsGte, String statisticsLt, Integer pageNum, Integer pageSize) {
        PageHelper.orderBy(" ctime DESC ");
        IPage<DwsFhlMkmsAuthorActionDay> page = new Page<>(pageNum, pageSize);
        IPage<DwsFhlMkmsAuthorActionDay> awemePage = dwsFhlMkmsAuthorActionDayMapper.getPage(page, principalId, statisticsGte, statisticsLt);
        return BasePageVO.restPage(pageNum, (int) awemePage.getSize(), (int) awemePage.getTotal(), (int) awemePage.getPages(), awemePage.getRecords());
    }

}
